/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2178;
import net.minecraft.class_2179;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2248;
import net.minecraft.class_2262;
import net.minecraft.class_2264;
import net.minecraft.class_2265;
import net.minecraft.class_2270;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.commands.AxisArgumentType;
import qouteall.imm_ptl.core.commands.PortalAnimationCommand;
import qouteall.imm_ptl.core.commands.PortalDebugCommands;
import qouteall.imm_ptl.core.commands.SubCommandArgumentType;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.PortalUtils;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.global_portals.BorderBarrierFiller;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.imm_ptl.core.portal.global_portals.WorldWrappingPortal;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalMatcher;
import qouteall.imm_ptl.core.portal.shape.BoxPortalShape;
import qouteall.imm_ptl.core.portal.shape.PortalShape;
import qouteall.imm_ptl.core.portal.shape.SpecialFlatPortalShape;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.GeometryUtil;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.Mesh2D;
import qouteall.q_misc_util.my_util.MyTaskList;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.RayTraceResult;
import qouteall.q_misc_util.my_util.SignalBiArged;
import qouteall.q_misc_util.my_util.Vec2d;
import qouteall.q_misc_util.my_util.WithDim;

public class PortalCommand {
    public static final SignalBiArged<class_3222, String> createCommandStickCommandSignal = new SignalBiArged();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 ctx) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"portal").requires(PortalCommand::canUsePortalCommand);
        PortalCommand.registerPortalTargetedCommands((LiteralArgumentBuilder<class_2168>)builder, ctx);
        LiteralArgumentBuilder animation = class_2170.method_9247((String)"animation");
        PortalAnimationCommand.registerPortalAnimationCommands((LiteralArgumentBuilder<class_2168>)animation);
        builder.then((ArgumentBuilder)animation);
        PortalCommand.registerCBPortalCommands((LiteralArgumentBuilder<class_2168>)builder);
        PortalCommand.registerUtilityCommands((LiteralArgumentBuilder<class_2168>)builder);
        LiteralArgumentBuilder global = (LiteralArgumentBuilder)class_2170.method_9247((String)"global").requires(commandSource -> commandSource.method_9259(2));
        PortalCommand.registerGlobalPortalCommands((LiteralArgumentBuilder<class_2168>)global);
        builder.then((ArgumentBuilder)global);
        LiteralArgumentBuilder debugBuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)"debug").requires(PortalCommand::canUsePortalCommand);
        PortalDebugCommands.registerDebugCommands((LiteralArgumentBuilder<class_2168>)debugBuilder);
        builder.then((ArgumentBuilder)debugBuilder);
        LiteralArgumentBuilder euler = class_2170.method_9247((String)"euler");
        PortalCommand.registerEulerCommands((LiteralArgumentBuilder<class_2168>)euler);
        builder.then((ArgumentBuilder)euler);
        dispatcher.register(builder);
    }

    public static boolean canUsePortalCommand(class_2168 commandSource) {
        class_1297 entity = commandSource.method_9228();
        if (entity instanceof class_3222 && IPGlobal.easeCreativePermission && ((class_3222)entity).method_7337()) {
            return true;
        }
        return commandSource.method_9259(2);
    }

    private static void registerGlobalPortalCommands(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9247((String)"create_inward_wrapping").then(class_2170.method_9244((String)"p1", (ArgumentType)class_2264.method_9701()).then(class_2170.method_9244((String)"p2", (ArgumentType)class_2264.method_9701()).executes(context -> {
            class_2265 p1 = class_2264.method_9702((CommandContext)context, (String)"p1");
            class_2265 p2 = class_2264.method_9702((CommandContext)context, (String)"p2");
            WorldWrappingPortal.invokeAddWrappingZone(((class_2168)context.getSource()).method_9225(), p1.comp_638(), p1.comp_639(), p2.comp_638(), p2.comp_639(), true, text -> ((class_2168)context.getSource()).method_9226(() -> text, false));
            return 0;
        }))));
        builder.then(class_2170.method_9247((String)"create_outward_wrapping").then(class_2170.method_9244((String)"p1", (ArgumentType)class_2264.method_9701()).then(class_2170.method_9244((String)"p2", (ArgumentType)class_2264.method_9701()).executes(context -> {
            class_2265 p1 = class_2264.method_9702((CommandContext)context, (String)"p1");
            class_2265 p2 = class_2264.method_9702((CommandContext)context, (String)"p2");
            WorldWrappingPortal.invokeAddWrappingZone(((class_2168)context.getSource()).method_9225(), p1.comp_638(), p1.comp_639(), p2.comp_638(), p2.comp_639(), false, text -> ((class_2168)context.getSource()).method_9226(() -> text, false));
            return 0;
        }))));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove_wrapping_zone").executes(context -> {
            WorldWrappingPortal.invokeRemoveWrappingZone(((class_2168)context.getSource()).method_9225(), ((class_2168)context.getSource()).method_9222(), text -> ((class_2168)context.getSource()).method_9226(() -> text, false));
            return 0;
        })).then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int id = IntegerArgumentType.getInteger((CommandContext)context, (String)"id");
            WorldWrappingPortal.invokeRemoveWrappingZone(((class_2168)context.getSource()).method_9225(), id, text -> ((class_2168)context.getSource()).method_9226(() -> text, false));
            return 0;
        })));
        builder.then(class_2170.method_9247((String)"view_wrapping_zones").executes(context -> {
            WorldWrappingPortal.invokeViewWrappingZones(((class_2168)context.getSource()).method_9225(), text -> ((class_2168)context.getSource()).method_9226(() -> text, false));
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear_wrapping_border").executes(context -> {
            BorderBarrierFiller.onCommandExecuted(((class_2168)context.getSource()).method_9207());
            return 0;
        })).then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int id = IntegerArgumentType.getInteger((CommandContext)context, (String)"id");
            BorderBarrierFiller.onCommandExecuted(((class_2168)context.getSource()).method_9207(), id);
            return 0;
        })));
        builder.then(class_2170.method_9247((String)"connect_floor").then(class_2170.method_9244((String)"from", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2181.method_9288()).executes(context -> {
            class_5321 from = class_2181.method_9289((CommandContext)context, (String)"from").method_27983();
            class_5321 to = class_2181.method_9289((CommandContext)context, (String)"to").method_27983();
            VerticalConnectingPortal.connect((class_5321<class_1937>)from, VerticalConnectingPortal.ConnectorType.floor, (class_5321<class_1937>)to);
            return 0;
        }))));
        builder.then(class_2170.method_9247((String)"connect_ceil").then(class_2170.method_9244((String)"from", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2181.method_9288()).executes(context -> {
            class_5321 from = class_2181.method_9289((CommandContext)context, (String)"from").method_27983();
            class_5321 to = class_2181.method_9289((CommandContext)context, (String)"to").method_27983();
            VerticalConnectingPortal.connect((class_5321<class_1937>)from, VerticalConnectingPortal.ConnectorType.ceil, (class_5321<class_1937>)to);
            return 0;
        }))));
        builder.then(class_2170.method_9247((String)"connection_floor_remove").then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).executes(context -> {
            class_5321 dim = class_2181.method_9289((CommandContext)context, (String)"dim").method_27983();
            VerticalConnectingPortal.removeConnectingPortal(VerticalConnectingPortal.ConnectorType.floor, (class_5321<class_1937>)dim);
            return 0;
        })));
        builder.then(class_2170.method_9247((String)"connection_ceil_remove").then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).executes(context -> {
            class_5321 dim = class_2181.method_9289((CommandContext)context, (String)"dim").method_27983();
            VerticalConnectingPortal.removeConnectingPortal(VerticalConnectingPortal.ConnectorType.ceil, (class_5321<class_1937>)dim);
            return 0;
        })));
        builder.then(class_2170.method_9247((String)"view_global_portals").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            PortalCommand.sendMessage((CommandContext<class_2168>)context, Helper.myToString(GlobalPortalStorage.getGlobalPortals(player.method_37908()).stream()));
            return 0;
        }));
        builder.then(class_2170.method_9247((String)"convert_normal_portal_to_global_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, GlobalPortalStorage::convertNormalPortalIntoGlobalPortal)));
        builder.then(class_2170.method_9247((String)"convert_global_portal_to_normal_portal").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            Portal portal = PortalCommand.getPlayerPointingPortal(player, true);
            if (portal == null) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"You are not pointing to any portal"), false);
                return 0;
            }
            if (!portal.getIsGlobal()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"You are not pointing to a global portal"), false);
                return 0;
            }
            if (player.method_19538().method_1022(portal.getOriginPos()) > 64.0) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("You are too far away from the portal's center " + String.valueOf(portal))), false);
                return 0;
            }
            GlobalPortalStorage.convertGlobalPortalIntoNormalPortal(portal);
            return 0;
        }));
        builder.then(class_2170.method_9247((String)"delete_global_portal").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            Portal portal = PortalCommand.getPlayerPointingPortal(player, true);
            if (portal == null) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"You are not pointing to any portal"), false);
                return 0;
            }
            if (!portal.getIsGlobal()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"You are not pointing to a global portal"), false);
                return 0;
            }
            GlobalPortalStorage.get((class_3218)portal.method_37908()).removePortal(portal);
            return 0;
        }));
    }

    private static void registerPortalTargetedCommands(LiteralArgumentBuilder<class_2168> builder, class_7157 ctx) {
        builder.then(class_2170.method_9247((String)"view_portal_data").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> PortalCommand.sendPortalInfo((CommandContext<class_2168>)context, portal))));
        builder.then(class_2170.method_9247((String)"set_portal_custom_name").then(class_2170.method_9244((String)"name", (ArgumentType)class_2178.method_9281((class_7157)ctx)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            class_2561 name = class_2178.method_9280((CommandContext)context, (String)"name");
            portal.method_5665(name);
        }))));
        builder.then(class_2170.method_9247((String)"delete_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            PortalCommand.sendMessage((CommandContext<class_2168>)context, "deleted " + String.valueOf(portal));
            portal.method_5650(class_1297.class_5529.field_26998);
        })));
        builder.then(class_2170.method_9247((String)"set_portal_nbt").then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            class_2487 newNbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
            PortalCommand.invokeSetPortalNbt((CommandContext<class_2168>)context, portal, newNbt);
        }))));
        builder.then(class_2170.method_9247((String)"nbt").then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            class_2487 newNbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
            PortalCommand.invokeSetPortalNbt((CommandContext<class_2168>)context, portal, newNbt);
        }))));
        builder.then(class_2170.method_9247((String)"set_portal_destination").then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"dest", (ArgumentType)class_2277.method_9735((boolean)false)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            PortalCommand.sendEditBiWayPortalWarning((CommandContext<class_2168>)context, portal);
            portal.setDestDim((class_5321<class_1937>)class_2181.method_9289((CommandContext)context, (String)"dim").method_27983());
            portal.setDestination(class_2277.method_9736((CommandContext)context, (String)"dest"));
            PortalCommand.reloadPortal(portal);
            PortalCommand.sendMessage((CommandContext<class_2168>)context, portal.toString());
        })))));
        PortalCommand.registerPortalTargetedCommandWithRotationArgument(builder, "set_portal_rotation", (p, r) -> p.setRotation((DQuaternion)r));
        PortalCommand.registerPortalTargetedCommandWithRotationArgument(builder, "rotate_portal_body", (p, r) -> {
            if (r != null) {
                PortalManipulation.rotatePortalBody(p, r);
            }
        });
        PortalCommand.registerPortalTargetedCommandWithRotationArgument(builder, "rotate_portal_rotation", (portal, rot) -> {
            if (rot != null) {
                DQuaternion rotation = portal.getRotation();
                if (rotation == null) {
                    portal.setRotation((DQuaternion)rot);
                } else {
                    portal.setRotation(rotation.hamiltonProduct((DQuaternion)rot));
                }
            }
        });
        builder.then(class_2170.method_9247((String)"complete_bi_way_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> PortalCommand.invokeCompleteBiWayPortal((CommandContext<class_2168>)context, portal))));
        builder.then(class_2170.method_9247((String)"complete_bi_faced_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> PortalCommand.invokeCompleteBiFacedPortal((CommandContext<class_2168>)context, portal))));
        builder.then(class_2170.method_9247((String)"complete_bi_way_bi_faced_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> PortalCommand.invokeCompleteBiWayBiFacedPortal((CommandContext<class_2168>)context, portal))));
        builder.then(class_2170.method_9247((String)"remove_connected_portals").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            PortalExtension.get((Portal)portal).bindCluster = false;
            PortalCommand.reloadPortal(portal);
            PortalManipulation.removeConnectedPortals(portal, p -> PortalCommand.sendMessage((CommandContext<class_2168>)context, "Removed " + String.valueOf(p)));
        })));
        builder.then(class_2170.method_9247((String)"eradicate_portal_clutter").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            PortalManipulation.removeConnectedPortals(portal, p -> PortalCommand.sendMessage((CommandContext<class_2168>)context, "Removed " + String.valueOf(p)));
            portal.method_5650(class_1297.class_5529.field_26998);
            PortalCommand.sendMessage((CommandContext<class_2168>)context, "Deleted " + String.valueOf(portal));
        })));
        builder.then(class_2170.method_9247((String)"eradicate_portal_cluster").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            HashSet<Portal> removed = new HashSet<Portal>();
            PortalManipulation.removeConnectedPortals(portal, removed::add);
            portal.method_5650(class_1297.class_5529.field_26998);
            removed.add(portal);
            PortalCommand.sendMessage((CommandContext<class_2168>)context, "Deleted %d portal entities".formatted(removed.size()));
        })));
        builder.then(class_2170.method_9247((String)"move_portal").then(class_2170.method_9244((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            try {
                PortalCommand.sendEditBiWayPortalWarning((CommandContext<class_2168>)context, portal);
                double distance = DoubleArgumentType.getDouble((CommandContext)context, (String)"distance");
                class_3222 player = ((class_2168)context.getSource()).method_9207();
                class_243 viewVector = player.method_5720();
                class_2350 facing = class_2350.method_10142((double)viewVector.field_1352, (double)viewVector.field_1351, (double)viewVector.field_1350);
                class_243 offset = class_243.method_24954((class_2382)facing.method_10163()).method_1021(distance);
                portal.method_5814(portal.method_23317() + offset.field_1352, portal.method_23318() + offset.field_1351, portal.method_23321() + offset.field_1350);
                PortalCommand.reloadPortal(portal);
            }
            catch (CommandSyntaxException e) {
                PortalCommand.sendMessage((CommandContext<class_2168>)context, "This command can only be invoked by player");
            }
        }))));
        builder.then(class_2170.method_9247((String)"move_portal_destination").then(class_2170.method_9244((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            try {
                PortalCommand.sendEditBiWayPortalWarning((CommandContext<class_2168>)context, portal);
                double distance = DoubleArgumentType.getDouble((CommandContext)context, (String)"distance");
                class_3222 player = ((class_2168)context.getSource()).method_9207();
                class_243 viewVector = player.method_5720();
                class_2350 facing = class_2350.method_10142((double)viewVector.field_1352, (double)viewVector.field_1351, (double)viewVector.field_1350);
                class_243 offset = class_243.method_24954((class_2382)facing.method_10163()).method_1021(distance);
                portal.setDestination(portal.getDestPos().method_1019(portal.transformLocalVecNonScale(offset)));
                PortalCommand.reloadPortal(portal);
            }
            catch (CommandSyntaxException e) {
                PortalCommand.sendMessage((CommandContext<class_2168>)context, "This command can only be invoked by player");
            }
        }))));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set_portal_specific_accessor").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> PortalCommand.removeSpecificAccessor((CommandContext<class_2168>)context, portal)))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> PortalCommand.setSpecificAccessor((CommandContext<class_2168>)context, portal, class_2186.method_9313((CommandContext)context, (String)"player"))))));
        builder.then(class_2170.method_9247((String)"multidest").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> PortalCommand.removeMultidestEntry((CommandContext<class_2168>)context, portal, class_2186.method_9315((CommandContext)context, (String)"player"))))).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"destination", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"isBiFaced", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"isBiWay", (ArgumentType)BoolArgumentType.bool()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> PortalCommand.setMultidestEntry((CommandContext<class_2168>)context, portal, class_2186.method_9315((CommandContext)context, (String)"player"), (class_5321<class_1937>)class_2181.method_9289((CommandContext)context, (String)"dimension").method_27983(), class_2277.method_9736((CommandContext)context, (String)"destination"), BoolArgumentType.getBool((CommandContext)context, (String)"isBiFaced"), BoolArgumentType.getBool((CommandContext)context, (String)"isBiWay"))))))))));
        builder.then(class_2170.method_9247((String)"make_portal_round").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            PortalManipulation.makePortalRound(portal, 30);
            PortalCommand.reloadPortal(portal);
        })));
        builder.then(class_2170.method_9247((String)"set_portal_scale").then(class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            portal.setScaling(scale);
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(class_2170.method_9247((String)"multiply_portal_scale").then(class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            portal.setScaling(portal.getScaling() * scale);
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(class_2170.method_9247((String)"divide_portal_scale").then(class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            portal.setScaling(portal.getScaling() / scale);
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(class_2170.method_9247((String)"set_portal_destination_to").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            class_1297 entity = class_2186.method_9313((CommandContext)context, (String)"entity");
            portal.setDestDim((class_5321<class_1937>)entity.method_37908().method_27983());
            portal.setDestination(entity.method_19538());
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(class_2170.method_9247((String)"set_portal_position").then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9735((boolean)false)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            class_3218 targetWorld = class_2181.method_9289((CommandContext)context, (String)"dim");
            class_243 pos = class_2277.method_9736((CommandContext)context, (String)"pos");
            if (targetWorld == portal.method_37908()) {
                portal.setOriginPos(pos);
                PortalCommand.reloadPortal(portal);
            } else {
                ServerTeleportationManager.teleportEntityGeneral(portal, pos, targetWorld);
            }
            PortalCommand.sendMessage((CommandContext<class_2168>)context, portal.toString());
        })))));
        builder.then(class_2170.method_9247((String)"set_portal_position_to").then(class_2170.method_9244((String)"targetEntity", (ArgumentType)class_2186.method_9309()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            class_1297 targetEntity = class_2186.method_9313((CommandContext)context, (String)"targetEntity");
            if (targetEntity.method_37908() == portal.method_37908()) {
                portal.setOriginPos(targetEntity.method_19538());
                PortalCommand.reloadPortal(portal);
            } else {
                ServerTeleportationManager.teleportEntityGeneral(portal, targetEntity.method_19538(), (class_3218)targetEntity.method_37908());
            }
            PortalCommand.sendMessage((CommandContext<class_2168>)context, portal.toString());
        }))));
        builder.then(class_2170.method_9247((String)"reset_portal_orientation").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            UnilateralPortalState thisSideState = portal.getThisSideState();
            portal.setThisSideState(new UnilateralPortalState.Builder().from(thisSideState).orientation(DQuaternion.identity).build());
            PortalCommand.reloadPortal(portal);
        })));
        builder.then(class_2170.method_9247((String)"relatively_move_portal").then(class_2170.method_9244((String)"offset", (ArgumentType)class_2277.method_9735((boolean)false)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            class_243 offset = class_2277.method_9736((CommandContext)context, (String)"offset");
            class_243 offsetTransformed = portal.transformLocalVec(offset);
            portal.setOriginPos(portal.getOriginPos().method_1019(offsetTransformed));
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(class_2170.method_9247((String)"relatively_move_portal_destination").then(class_2170.method_9244((String)"offset", (ArgumentType)class_2277.method_9735((boolean)false)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            class_243 offset = class_2277.method_9736((CommandContext)context, (String)"offset");
            portal.setDestination(portal.getDestPos().method_1019(portal.transformLocalVec(portal.getAxisW()).method_1021(offset.field_1352)).method_1019(portal.transformLocalVec(portal.getAxisH()).method_1021(offset.field_1351)).method_1019(portal.transformLocalVec(portal.getNormal()).method_1021(offset.field_1350)));
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(class_2170.method_9247((String)"set_portal_size").then(class_2170.method_9244((String)"width", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(class_2170.method_9244((String)"height", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            portal.setWidth(width);
            portal.setHeight(height);
            portal.setPortalShapeToDefault();
            PortalCommand.reloadPortal(portal);
        })))));
        builder.then(class_2170.method_9247((String)"adjust_portal_to_fit_square_frame").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            PortalCommand.adjustPortalAreaToFitFrame(portal);
            PortalCommand.reloadPortal(portal);
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add_command_on_teleported").requires(serverCommandSource -> serverCommandSource.method_9259(2))).then(class_2170.method_9244((String)"subCommand", (ArgumentType)SubCommandArgumentType.instance).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            String subCommand = SubCommandArgumentType.get(context, "subCommand");
            if (portal.getCommandsOnTeleported() == null) {
                portal.setCommandsOnTeleported(new ArrayList<String>());
            }
            portal.getCommandsOnTeleported().add(subCommand);
            portal.reloadAndSyncToClient();
            PortalCommand.sendPortalInfo((CommandContext<class_2168>)context, portal);
        }))));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove_command_on_teleported_at").requires(serverCommandSource -> serverCommandSource.method_9259(2))).then(class_2170.method_9244((String)"indexStartingFromZero", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            if (portal.getCommandsOnTeleported() == null) {
                return;
            }
            int index = IntegerArgumentType.getInteger((CommandContext)context, (String)"indexStartingFromZero");
            if (index >= portal.getCommandsOnTeleported().size()) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Index out of range"));
                return;
            }
            portal.getCommandsOnTeleported().remove(index);
            portal.reloadAndSyncToClient();
            PortalCommand.sendPortalInfo((CommandContext<class_2168>)context, portal);
        }))));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set_command_on_teleported_at").requires(serverCommandSource -> serverCommandSource.method_9259(2))).then(class_2170.method_9244((String)"indexStartingFromZero", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).then(class_2170.method_9244((String)"subCommand", (ArgumentType)SubCommandArgumentType.instance).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            if (portal.getCommandsOnTeleported() == null) {
                return;
            }
            int index = IntegerArgumentType.getInteger((CommandContext)context, (String)"indexStartingFromZero");
            if (index >= portal.getCommandsOnTeleported().size()) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Index out of range"));
                return;
            }
            String subCommand = SubCommandArgumentType.get(context, "subCommand");
            portal.getCommandsOnTeleported().set(index, subCommand);
            portal.reloadAndSyncToClient();
            PortalCommand.sendPortalInfo((CommandContext<class_2168>)context, portal);
        })))));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear_commands_on_teleported").requires(serverCommandSource -> serverCommandSource.method_9259(2))).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            portal.setCommandsOnTeleported(null);
            portal.reloadAndSyncToClient();
            PortalCommand.sendPortalInfo((CommandContext<class_2168>)context, portal);
        })));
        builder.then(class_2170.method_9247((String)"turn_info_fake_enterable_mirror").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> PortalCommand.invokeTurnIntoFakeEnterableMirror((CommandContext<class_2168>)context, portal))));
        LiteralArgumentBuilder shapeBuilder = class_2170.method_9247((String)"shape");
        shapeBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"sculpt").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> PortalCommand.invokeSculpt((CommandContext<class_2168>)context, portal, true)))).then(class_2170.method_9244((String)"adjustPortalBounds", (ArgumentType)BoolArgumentType.bool()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            boolean adjustPortalBounds = BoolArgumentType.getBool((CommandContext)context, (String)"adjustPortalBounds");
            PortalCommand.invokeSculpt((CommandContext<class_2168>)context, portal, adjustPortalBounds);
        }))));
        shapeBuilder.then(class_2170.method_9247((String)"reset").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            portal.setPortalShapeToDefault();
            PortalCommand.reloadPortal(portal);
        })));
        builder.then((ArgumentBuilder)shapeBuilder);
        LiteralArgumentBuilder toggleBuilder = class_2170.method_9247((String)"toggle");
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<class_2168>)toggleBuilder, "interactable", Portal::isInteractable, Portal::setInteractable);
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<class_2168>)toggleBuilder, "teleportable", Portal::isTeleportable, Portal::setTeleportable);
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<class_2168>)toggleBuilder, "teleportChangesScale", Portal::isTeleportChangesScale, Portal::setTeleportChangesScale);
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<class_2168>)toggleBuilder, "teleportChangesGravity", Portal::isTeleportChangesGravity, Portal::setTeleportChangesGravity);
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<class_2168>)toggleBuilder, "fuseView", Portal::isFuseView, Portal::setFuseView);
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<class_2168>)toggleBuilder, "visible", Portal::isVisible, Portal::setIsVisible);
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<class_2168>)toggleBuilder, "crossPortalCollisionEnabled", Portal::isCrossPortalCollisionEnabled, Portal::setCrossPortalCollisionEnabled);
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<class_2168>)toggleBuilder, "doRenderPayer", Portal::getDoRenderPlayer, Portal::setDoRenderPlayer);
        builder.then((ArgumentBuilder)toggleBuilder);
    }

    private static void registerToggleCommand(LiteralArgumentBuilder<class_2168> builder, String property, Function<Portal, Boolean> getter, BiConsumer<Portal, Boolean> setter) {
        builder.then(class_2170.method_9247((String)property).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            boolean newValue = (Boolean)getter.apply(portal) == false;
            setter.accept(portal, newValue);
            PortalCommand.reloadPortal(portal);
            PortalCommand.sendMessage((CommandContext<class_2168>)context, "Set %s to %s".formatted(property, newValue));
        })));
    }

    private static void invokeSetPortalNbt(CommandContext<class_2168> context, Portal portal, class_2487 newNbt) {
        if (newNbt.method_10545("commandsOnTeleported") && !((class_2168)context.getSource()).method_9259(2)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You do not have the permission to set commandsOnTeleported"));
            return;
        }
        if (newNbt.method_10545("dimensionTo")) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Cannot change tag dimensionTo. use command /portal set_portal_destination"));
            return;
        }
        portal.updatePortalFromNbt(newNbt);
        PortalCommand.reloadPortal(portal);
        PortalCommand.sendPortalInfo(context, portal);
    }

    private static void adjustPortalAreaToFitFrame(Portal portal) {
        portal.setPortalShapeToDefault();
        class_2338 origin = class_2338.method_49638((class_2374)portal.getOriginPos());
        class_2350 portalNormalDirection = class_2350.method_10142((double)portal.getNormal().field_1352, (double)portal.getNormal().field_1351, (double)portal.getNormal().field_1350);
        class_1937 world = portal.method_37908();
        IntBox boxArea = Helper.expandRectangle(origin, pos -> world.method_8320(pos).method_26215(), portalNormalDirection.method_10166());
        class_238 portalBox = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (class_2350 direction : class_2350.values()) {
            IntBox outerSurface = boxArea.getSurfaceLayer(direction).getMoved(direction.method_10163());
            class_238 collisionBox = McHelper.getWallBox(world, outerSurface);
            if (collisionBox == null) {
                collisionBox = outerSurface.toRealNumberBox();
            }
            portalBox = Helper.replaceBoxCoordinate(portalBox, direction, Helper.getBoxCoordinate(collisionBox, direction.method_10153()));
        }
        double portalNormalCoordinate = Helper.getCoordinate(portal.getOriginPos(), portalNormalDirection.method_10166());
        portalBox = Helper.replaceBoxCoordinate(portalBox, portalNormalDirection, portalNormalCoordinate);
        portalBox = Helper.replaceBoxCoordinate(portalBox, portalNormalDirection.method_10153(), portalNormalCoordinate);
        PortalAPI.setPortalOrthodoxShape(portal, portalNormalDirection, portalBox);
    }

    public static void reloadPortal(Portal portal) {
        portal.reloadPortal();
    }

    private static void registerPortalTargetedCommandWithRotationArgument(LiteralArgumentBuilder<class_2168> builder, String literal, BiConsumer<Portal, DQuaternion> func) {
        builder.then(class_2170.method_9247((String)literal).then(class_2170.method_9244((String)"rotatingAxis", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            class_243 rotatingAxis = class_2277.method_9736((CommandContext)context, (String)"rotatingAxis").method_1029();
            PortalCommand.doInvokeRotationCommandWithAngleArgument(func, (CommandContext<class_2168>)context, portal, rotatingAxis);
        })))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)(literal + "_along")).then(class_2170.method_9247((String)"x").then(class_2170.method_9244((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> PortalCommand.doInvokeRotationCommandWithAngleArgument(func, (CommandContext<class_2168>)context, portal, new class_243(1.0, 0.0, 0.0))))))).then(class_2170.method_9247((String)"y").then(class_2170.method_9244((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> PortalCommand.doInvokeRotationCommandWithAngleArgument(func, (CommandContext<class_2168>)context, portal, new class_243(0.0, 1.0, 0.0))))))).then(class_2170.method_9247((String)"z").then(class_2170.method_9244((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> PortalCommand.doInvokeRotationCommandWithAngleArgument(func, (CommandContext<class_2168>)context, portal, new class_243(0.0, 0.0, 1.0)))))));
    }

    private static void doInvokeRotationCommandWithAngleArgument(BiConsumer<Portal, DQuaternion> func, CommandContext<class_2168> context, Portal portal, class_243 rotatingAxis) {
        PortalCommand.sendEditBiWayPortalWarning(context, portal);
        double angleDegrees = DoubleArgumentType.getDouble(context, (String)"angleDegrees");
        DQuaternion rot = angleDegrees != 0.0 ? DQuaternion.rotationByDegrees(rotatingAxis, (float)angleDegrees) : null;
        func.accept(portal, rot);
        PortalCommand.reloadPortal(portal);
    }

    private static void registerCBPortalCommands(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9247((String)"cb_make_portal").then(class_2170.method_9244((String)"width", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"height", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"from", (ArgumentType)class_2186.method_9309()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"to", (ArgumentType)class_2186.method_9309()).executes(context -> {
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            class_1297 fromEntity = class_2186.method_9313((CommandContext)context, (String)"from");
            class_1297 toEntity = class_2186.method_9313((CommandContext)context, (String)"to");
            PortalCommand.invokeCbMakePortal(width, height, fromEntity, toEntity, "");
            return 0;
        })).then(class_2170.method_9244((String)"portalName", (ArgumentType)StringArgumentType.string()).executes(context -> {
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            class_1297 fromEntity = class_2186.method_9313((CommandContext)context, (String)"from");
            class_1297 toEntity = class_2186.method_9313((CommandContext)context, (String)"to");
            String portalName = StringArgumentType.getString((CommandContext)context, (String)"portalName");
            PortalCommand.invokeCbMakePortal(width, height, fromEntity, toEntity, portalName);
            return 0;
        })))))));
    }

    private static void invokeCbMakePortal(double width, double height, class_1297 fromEntity, class_1297 toEntity, String portalName) {
        Portal portal = (Portal)Portal.ENTITY_TYPE.method_5883(fromEntity.method_37908());
        portal.method_5814(fromEntity.method_23317(), fromEntity.method_23318(), fromEntity.method_23321());
        portal.setDestDim((class_5321<class_1937>)toEntity.method_37908().method_27983());
        portal.setDestination(toEntity.method_19538());
        portal.setWidth(width);
        portal.setHeight(height);
        class_243 normal = fromEntity.method_5828(1.0f);
        class_243 rightVec = PortalCommand.getRightVec(fromEntity);
        class_243 axisH = rightVec.method_1036(normal).method_1029();
        portal.setAxisW(rightVec);
        portal.setAxisH(axisH);
        portal.method_5665((class_2561)class_2561.method_43470((String)portalName));
        McHelper.spawnServerEntity(portal);
    }

    private static void registerUtilityCommands(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpme").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(context -> {
            class_1297 entity = class_2186.method_9313((CommandContext)context, (String)"target");
            ServerTeleportationManager.of(((class_2168)context.getSource()).method_9211()).forceTeleportPlayer(((class_2168)context.getSource()).method_9207(), (class_5321<class_1937>)entity.method_37908().method_27983(), entity.method_19538());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"imm_ptl.command.tpme.success", (Object[])new Object[]{entity.method_5476()}), true);
            return 1;
        }))).then(class_2170.method_9244((String)"dest", (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_243 dest = class_2277.method_9736((CommandContext)context, (String)"dest");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            ServerTeleportationManager.of(((class_2168)context.getSource()).method_9211()).forceTeleportPlayer(player, (class_5321<class_1937>)player.method_37908().method_27983(), dest);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"imm_ptl.command.tpme.success", (Object[])new Object[]{dest.toString()}), true);
            return 1;
        }))).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"dest", (ArgumentType)class_2277.method_9737()).executes(context -> {
            class_5321 dim = class_2181.method_9289((CommandContext)context, (String)"dim").method_27983();
            class_243 dest = class_2277.method_9736((CommandContext)context, (String)"dest");
            ServerTeleportationManager.of(((class_2168)context.getSource()).method_9211()).forceTeleportPlayer(((class_2168)context.getSource()).method_9207(), (class_5321<class_1937>)dim, dest);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"imm_ptl.command.tpme.success", (Object[])new Object[]{McHelper.dimensionTypeId((class_5321<class_1937>)dim).toString() + dest.toString()}), true);
            return 1;
        }))));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tp").requires(commandSource -> commandSource.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"from", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2186.method_9309()).executes(context -> {
            Collection entities = class_2186.method_9317((CommandContext)context, (String)"from");
            class_1297 target = class_2186.method_9313((CommandContext)context, (String)"to");
            int numTeleported = PortalCommand.teleport(entities, (class_5321<class_1937>)target.method_37908().method_27983(), target.method_19538());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"imm_ptl.command.tp.success", (Object[])new Object[]{numTeleported, target.method_5476()}), true);
            return numTeleported;
        }))).then(class_2170.method_9244((String)"dest", (ArgumentType)class_2277.method_9737()).executes(context -> {
            Collection entities = class_2186.method_9317((CommandContext)context, (String)"from");
            class_243 dest = class_2277.method_9736((CommandContext)context, (String)"dest");
            int numTeleported = PortalCommand.teleport(entities, (class_5321<class_1937>)((class_2168)context.getSource()).method_9225().method_27983(), dest);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"imm_ptl.command.tp.success", (Object[])new Object[]{numTeleported, dest.toString()}), true);
            return numTeleported;
        }))).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"dest", (ArgumentType)class_2277.method_9737()).executes(context -> {
            Collection entities = class_2186.method_9317((CommandContext)context, (String)"from");
            class_5321 dim = class_2181.method_9289((CommandContext)context, (String)"dim").method_27983();
            class_243 dest = class_2277.method_9736((CommandContext)context, (String)"dest");
            int numTeleported = PortalCommand.teleport(entities, (class_5321<class_1937>)((class_2168)context.getSource()).method_9225().method_27983(), dest);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"imm_ptl.command.tp.success", (Object[])new Object[]{numTeleported, McHelper.dimensionTypeId((class_5321<class_1937>)dim).toString() + dest.toString()}), true);
            return numTeleported;
        })))));
        builder.then(class_2170.method_9247((String)"make_portal").then(class_2170.method_9244((String)"width", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"height", (ArgumentType)DoubleArgumentType.doubleArg()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"to", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"dest", (ArgumentType)class_2277.method_9735((boolean)false)).executes(PortalCommand::placePortalAbsolute))).then(class_2170.method_9247((String)"shift").then(class_2170.method_9244((String)"dist", (ArgumentType)DoubleArgumentType.doubleArg()).executes(PortalCommand::placePortalShift)))))));
        builder.then(class_2170.method_9247((String)"goback").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            ServerTeleportationManager serverTeleportationManager = ServerTeleportationManager.of(((class_2168)context.getSource()).method_9211());
            WithDim<class_243> lastPos = serverTeleportationManager.lastPosition.get(player);
            if (lastPos == null) {
                PortalCommand.sendMessage((CommandContext<class_2168>)context, "You haven't teleported");
            } else {
                serverTeleportationManager.forceTeleportPlayer(player, lastPos.dimension(), lastPos.value());
            }
            return 0;
        }));
        builder.then(class_2170.method_9247((String)"create_small_inward_wrapping").then(class_2170.method_9244((String)"p1", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"p2", (ArgumentType)class_2277.method_9735((boolean)false)).executes(context -> {
            class_243 p1 = class_2277.method_9736((CommandContext)context, (String)"p1");
            class_243 p2 = class_2277.method_9736((CommandContext)context, (String)"p2");
            class_238 box = new class_238(p1, p2);
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            PortalCommand.addSmallWorldWrappingPortals(box, world, true);
            return 0;
        }))));
        builder.then(class_2170.method_9247((String)"create_small_outward_wrapping").then(class_2170.method_9244((String)"p1", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"p2", (ArgumentType)class_2277.method_9735((boolean)false)).executes(context -> {
            class_243 p1 = class_2277.method_9736((CommandContext)context, (String)"p1");
            class_243 p2 = class_2277.method_9736((CommandContext)context, (String)"p2");
            class_238 box = new class_238(p1, p2);
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            PortalCommand.addSmallWorldWrappingPortals(box, world, false);
            return 0;
        }))));
        builder.then(class_2170.method_9247((String)"create_scaled_box_view").then(class_2170.method_9244((String)"p1", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"p2", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"placeTargetEntity", (ArgumentType)class_2186.method_9309()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"biWay", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            PortalCommand.invokeOldCreateScaledViewCommand((CommandContext<class_2168>)context, false, false, false, false, BoolArgumentType.getBool((CommandContext)context, (String)"biWay"));
            return 0;
        })).then(class_2170.method_9244((String)"teleportChangesScale", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean teleportChangesScale = BoolArgumentType.getBool((CommandContext)context, (String)"teleportChangesScale");
            PortalCommand.invokeOldCreateScaledViewCommand((CommandContext<class_2168>)context, teleportChangesScale, false, false, false, BoolArgumentType.getBool((CommandContext)context, (String)"biWay"));
            return 0;
        }))))))));
        builder.then(class_2170.method_9247((String)"create_scaled_box_view_optimized").then(class_2170.method_9244((String)"p1", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"p2", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"placeTargetEntity", (ArgumentType)class_2186.method_9309()).executes(context -> {
            class_2338 bp1 = class_2262.method_9697((CommandContext)context, (String)"p1");
            class_2338 bp2 = class_2262.method_9697((CommandContext)context, (String)"p2");
            IntBox intBox = new IntBox(bp1, bp2);
            class_1297 placeTargetEntity = class_2186.method_9313((CommandContext)context, (String)"placeTargetEntity");
            class_3218 boxWorld = (class_3218)placeTargetEntity.method_37908();
            class_238 area = intBox.toRealNumberBox();
            class_3218 areaWorld = ((class_2168)context.getSource()).method_9225();
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            double thisSideWidth = area.method_17939() / scale;
            double thisSideHeight = area.method_17940() / scale;
            double thisSideThickness = area.method_17941() / scale;
            Portal portal = (Portal)Portal.ENTITY_TYPE.method_5883((class_1937)boxWorld);
            assert (portal != null);
            portal.setDestinationDimension((class_5321<class_1937>)areaWorld.method_27983());
            portal.setOriginPos(placeTargetEntity.method_19538().method_1031(0.0, thisSideHeight / 2.0, 0.0));
            portal.setDestination(area.method_1005());
            portal.setOrientationRotation(DQuaternion.identity);
            portal.setPortalSize(thisSideWidth, thisSideHeight, thisSideThickness);
            portal.setPortalShape(BoxPortalShape.FACING_OUTWARDS);
            portal.setScaleTransformation(scale);
            portal.setFuseView(true);
            portal.setTeleportChangesScale(false);
            McHelper.spawnServerEntity(portal);
            Portal reverse = PortalAPI.createReversePortal(portal);
            McHelper.spawnServerEntity(reverse);
            return 0;
        }))))));
        builder.then(class_2170.method_9247((String)"create_connected_rooms").then(class_2170.method_9247((String)"roomSize").then(class_2170.method_9244((String)"roomSize", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9247((String)"roomNumber").then(class_2170.method_9244((String)"roomNumber", (ArgumentType)IntegerArgumentType.integer((int)2, (int)500)).executes(context -> {
            class_2338 roomSize = class_2262.method_9697((CommandContext)context, (String)"roomSize");
            int roomNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"roomNumber");
            PortalCommand.createConnectedRooms(((class_2168)context.getSource()).method_9225(), class_2338.method_49638((class_2374)((class_2168)context.getSource()).method_9222()), roomSize, roomNumber, text -> ((class_2168)context.getSource()).method_9226(() -> text, false));
            return 0;
        }))))));
        builder.then(class_2170.method_9247((String)"create_cube_surface_unwrapping").then(class_2170.method_9244((String)"boxL", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"boxH", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"length", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(context -> {
            class_2338 boxL = class_2262.method_9697((CommandContext)context, (String)"boxL");
            class_2338 boxH = class_2262.method_9697((CommandContext)context, (String)"boxH");
            IntBox box = new IntBox(boxL, boxH);
            int length = IntegerArgumentType.getInteger((CommandContext)context, (String)"length");
            class_2338 size = box.getSize();
            PortalCommand.createCubeSurfaceUnwrapping(((class_2168)context.getSource()).method_9225(), box.toRealNumberBox(), length);
            return 0;
        })))));
        builder.then(class_2170.method_9247((String)"adjust_rotation_to_connect").then(class_2170.method_9244((String)"portal1", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"portal2", (ArgumentType)class_2186.method_9309()).executes(context -> {
            class_1297 e1 = class_2186.method_9313((CommandContext)context, (String)"portal1");
            class_1297 e2 = class_2186.method_9313((CommandContext)context, (String)"portal2");
            if (!(e1 instanceof Portal)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"portal1 is not a portal entity"));
                return 0;
            }
            if (!(e2 instanceof Portal)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"portal2 is not a portal entity"));
                return 0;
            }
            Portal portal1 = (Portal)e1;
            Portal portal2 = (Portal)e2;
            portal1.setDestination(portal2.getOriginPos());
            portal2.setDestination(portal1.getOriginPos());
            PortalManipulation.adjustRotationToConnect(portal1, portal2);
            portal1.reloadAndSyncToClient();
            portal2.reloadAndSyncToClient();
            return 0;
        }))));
        builder.then(class_2170.method_9247((String)"rotate_portals_around").then(class_2170.method_9244((String)"portals", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"origin", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"axis", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"angle", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            Portal portal;
            Collection portals = class_2186.method_9317((CommandContext)context, (String)"portals");
            class_243 origin = class_2277.method_9736((CommandContext)context, (String)"origin");
            class_243 axis = class_2277.method_9736((CommandContext)context, (String)"axis").method_1029();
            double angle = DoubleArgumentType.getDouble((CommandContext)context, (String)"angle");
            DQuaternion quaternion = DQuaternion.rotationByDegrees(axis, angle);
            for (class_1297 entity : portals) {
                if (entity instanceof Portal) {
                    portal = (Portal)entity;
                    class_243 offset = portal.getOriginPos().method_1020(origin);
                    class_243 offsetRotated = quaternion.rotate(offset);
                    portal.setOriginPos(offsetRotated.method_1019(origin));
                    portal.setAxisW(quaternion.rotate(portal.getAxisW()));
                    portal.setAxisH(quaternion.rotate(portal.getAxisH()));
                    portal.setRotationTransformationD(portal.getRotationD().hamiltonProduct(quaternion.getConjugated()));
                    continue;
                }
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"the entity is not a portal"));
            }
            for (class_1297 entity : portals) {
                if (!(entity instanceof Portal)) continue;
                portal = (Portal)entity;
                PortalCommand.reloadPortal(portal);
            }
            return 0;
        }))))));
        builder.then(class_2170.method_9247((String)"scale_portals_relative_to_point").then(class_2170.method_9244((String)"portals", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"origin", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            Collection portals = class_2186.method_9317((CommandContext)context, (String)"portals");
            class_243 origin = class_2277.method_9736((CommandContext)context, (String)"origin");
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            ArrayList<Portal> portalsToReload = new ArrayList<Portal>();
            for (class_1297 entity : portals) {
                if (entity instanceof Portal) {
                    Portal portal = (Portal)entity;
                    class_243 offset = portal.getOriginPos().method_1020(origin);
                    class_243 newOrigin = offset.method_1021(scale).method_1019(origin);
                    PortalExtension extension = PortalExtension.get(portal);
                    if (extension.reversePortal != null) {
                        extension.reversePortal.setDestination(newOrigin);
                        extension.reversePortal.setScaling(extension.reversePortal.getScaling() / scale);
                        portalsToReload.add(extension.reversePortal);
                        continue;
                    }
                    portal.setOriginPos(newOrigin);
                    portal.setWidth(portal.getWidth() * scale);
                    portal.setHeight(portal.getHeight() * scale);
                    portalsToReload.add(portal);
                    continue;
                }
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"the entity is not a portal"));
            }
            for (Portal portal : portalsToReload) {
                PortalCommand.reloadPortal(portal);
            }
            return 0;
        })))));
        builder.then(class_2170.method_9247((String)"create_diagonal_portal").then(class_2170.method_9244((String)"fromPos", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"toPos", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"axis", (ArgumentType)AxisArgumentType.instance).executes(context -> {
            class_243 fromPos = class_2277.method_9736((CommandContext)context, (String)"fromPos");
            class_243 toPos = class_2277.method_9736((CommandContext)context, (String)"toPos");
            class_2350.class_2351 axis = AxisArgumentType.getAxis(context, "axis");
            class_243 axisVec = class_243.method_24954((class_2382)class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056).method_10163());
            class_243 delta = toPos.method_1020(fromPos);
            class_243 vecAlongAxis = axisVec.method_1021(delta.method_1026(axisVec));
            class_243 vecNotAlongAxis = delta.method_1020(vecAlongAxis);
            class_243 center = fromPos.method_1019(toPos).method_1021(0.5);
            Portal portal = (Portal)Portal.ENTITY_TYPE.method_5883((class_1937)((class_2168)context.getSource()).method_9225());
            assert (portal != null);
            portal.setOriginPos(center);
            portal.setOrientation(vecAlongAxis.method_1029(), vecNotAlongAxis.method_1029());
            portal.setWidth(vecAlongAxis.method_1033());
            portal.setHeight(vecNotAlongAxis.method_1033());
            portal.setDestination(center.method_1031(0.0, 10.0, 0.0));
            portal.setDestinationDimension((class_5321<class_1937>)((class_2168)context.getSource()).method_9225().method_27983());
            if (portal.getWidth() > 64.0 || portal.getHeight() > 64.0) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"portal size is too large"));
                return 0;
            }
            McHelper.spawnServerEntity(portal);
            Portal flippedPortal = PortalManipulation.createFlippedPortal(portal, Portal.ENTITY_TYPE);
            McHelper.spawnServerEntity(flippedPortal);
            return 0;
        })))));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"dimension_stack").requires(commandSource -> commandSource.method_9259(2))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            DimStackManagement.onDimensionStackCommandExecute(player);
            return 0;
        }));
        builder.then(class_2170.method_9247((String)"wiki").executes(context -> {
            ((class_2168)context.getSource()).method_9207().method_43496((class_2561)McHelper.getLinkText("https://qouteall.fun/immptl/wiki/Commands-Reference"));
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"create_command_stick").requires(serverCommandSource -> serverCommandSource.method_9259(2))).then(class_2170.method_9244((String)"command", (ArgumentType)SubCommandArgumentType.instance).executes(context -> {
            createCommandStickCommandSignal.emit(((class_2168)context.getSource()).method_9207(), SubCommandArgumentType.get(context, "command"));
            return 0;
        })));
    }

    private static void createCubeSurfaceUnwrapping(class_3218 world, class_238 box, double length) {
        class_243 boxSize = Helper.getBoxSize(box);
        class_243 boxCenter = box.method_1005();
        for (class_2350 face : class_2350.values()) {
            class_243 facingVec = class_243.method_24954((class_2382)face.method_10163());
            for (class_2350 sideDirection : Helper.getAnotherFourDirections(face.method_10166())) {
                class_243 sideDirectionVec = class_243.method_24954((class_2382)sideDirection.method_10163());
                class_243 edgeCenter = facingVec.method_1021(0.5).method_1019(sideDirectionVec.method_1021(0.5)).method_18806(boxSize).method_1019(boxCenter);
                class_243 portalOrigin = edgeCenter.method_1019(facingVec.method_1021(length / 2.0));
                class_243 portalDestination = edgeCenter.method_1019(sideDirectionVec.method_1021(length / 2.0));
                class_243 portalWAxis = sideDirectionVec.method_1036(facingVec);
                class_243 portalHAxis = facingVec;
                double width = Math.abs(boxSize.method_1026(portalWAxis));
                double height = length;
                DQuaternion rotationTransform = DQuaternion.getRotationBetween(facingVec, sideDirectionVec);
                Portal portal = (Portal)Portal.ENTITY_TYPE.method_5883((class_1937)world);
                portal.setOriginPos(portalOrigin);
                portal.setDestination(portalDestination);
                portal.setDestinationDimension((class_5321<class_1937>)world.method_27983());
                portal.setOrientationAndSize(portalWAxis, portalHAxis, width, height);
                portal.setRotationTransformationD(rotationTransform);
                portal.setTeleportChangesGravity(true);
                portal.portalTag = "imm_ptl:cube_surface_unwrapping";
                McHelper.spawnServerEntity(portal);
            }
        }
    }

    private static void createConnectedRooms(class_3218 world, class_2338 startingPos, class_2338 roomSize, int roomNumber, Consumer<class_2561> feedbackSender) {
        class_2338 roomAreaSize = roomSize.method_10069(2, 2, 2);
        ArrayList roomAreaList = new ArrayList();
        Helper.SimpleBox<class_2338> currentSearchingCenter = new Helper.SimpleBox<class_2338>(startingPos);
        ServerTaskList.of(world.method_8503()).addTask(MyTaskList.chainTask(MyTaskList.repeat(roomNumber, () -> MyTaskList.withDelay(20, MyTaskList.oneShotTask(() -> {
            currentSearchingCenter.obj = ((class_2338)currentSearchingCenter.obj).method_10081((class_2382)PortalCommand.getRandomShift(20));
            IntBox airCube = NetherPortalMatcher.findCubeAirAreaAtAnywhere(roomAreaSize.method_10069(6, 6, 6), (class_1936)world, (class_2338)currentSearchingCenter.obj, 128);
            if (airCube == null) {
                feedbackSender.accept((class_2561)class_2561.method_43470((String)"Cannot find space for placing room"));
                return;
            }
            airCube = airCube.getSubBoxInCenter(roomAreaSize);
            PortalCommand.fillRoomFrame(world, airCube, PortalCommand.getRandomBlock());
            roomAreaList.add(airCube);
        }))), MyTaskList.oneShotTask(() -> {
            Stream<IntBox> roomsStream = Stream.concat(roomAreaList.stream(), Stream.of((IntBox)roomAreaList.get(0)));
            Helper.wrapAdjacentAndMap(roomsStream, Pair::new).forEach(pair -> {
                IntBox room1Area = (IntBox)pair.getFirst();
                IntBox room2Area = (IntBox)pair.getSecond();
                IntBox room1 = room1Area.getAdjusted(1, 1, 1, -1, -1, -1);
                IntBox room2 = room2Area.getAdjusted(1, 1, 1, -1, -1, -1);
                Portal portal = (Portal)Portal.ENTITY_TYPE.method_5883((class_1937)world);
                Validate.notNull((Object)portal);
                portal.setOriginPos(room1.getCenterVec().method_1031((double)roomSize.method_10263() / 4.0, 0.0, 0.0));
                portal.setDestinationDimension((class_5321<class_1937>)world.method_27983());
                portal.setDestination(room2.getCenterVec().method_1031((double)roomSize.method_10263() / 4.0, 0.0, 0.0));
                portal.setOrientationAndSize(new class_243(1.0, 0.0, 0.0), new class_243(0.0, 1.0, 0.0), (double)roomSize.method_10263() / 2.0, roomSize.method_10264());
                portal.portalTag = "imm_ptl:room_connection";
                McHelper.spawnServerEntity(portal);
                Portal reversePortal = PortalAPI.createReversePortal(portal);
                McHelper.spawnServerEntity(reversePortal);
            });
            feedbackSender.accept((class_2561)class_2561.method_43470((String)"finished"));
        })));
    }

    private static class_2680 getRandomBlock() {
        class_2248 block;
        class_2680 state;
        while (!(state = (block = (class_2248)((class_6880.class_6883)class_7923.field_41175.method_10240(class_5819.method_43047()).get()).comp_349()).method_9564()).method_51367()) {
        }
        return state;
    }

    private static void fillRoomFrame(class_3218 world, IntBox roomArea, class_2680 blockState) {
        for (class_2350 direction : class_2350.values()) {
            IntBox surface = roomArea.getSurfaceLayer(direction);
            surface.fastStream().forEach(blockPos -> world.method_8501(blockPos, blockState));
        }
    }

    private static void invokeOldCreateScaledViewCommand(CommandContext<class_2168> context, boolean teleportChangesScale, boolean outerFuseView, boolean outerRenderingMergable, boolean innerRenderingMergable, boolean isBiWay) throws CommandSyntaxException {
        class_2338 bp1 = class_2262.method_9697(context, (String)"p1");
        class_2338 bp2 = class_2262.method_9697(context, (String)"p2");
        IntBox intBox = new IntBox(bp1, bp2);
        class_1297 placeTargetEntity = class_2186.method_9313(context, (String)"placeTargetEntity");
        class_3218 boxWorld = (class_3218)placeTargetEntity.method_37908();
        class_243 boxBottomCenter = placeTargetEntity.method_19538();
        class_238 area = intBox.toRealNumberBox();
        class_3218 areaWorld = ((class_2168)context.getSource()).method_9225();
        double scale = DoubleArgumentType.getDouble(context, (String)"scale");
        PortalManipulation.createScaledBoxView(areaWorld, area, boxWorld, boxBottomCenter, scale, isBiWay, teleportChangesScale, outerFuseView, outerRenderingMergable, innerRenderingMergable, false);
    }

    private static void addSmallWorldWrappingPortals(class_238 box, class_3218 world, boolean isInward) {
        for (class_2350 direction : class_2350.values()) {
            Portal portal = (Portal)Portal.ENTITY_TYPE.method_5883((class_1937)world);
            WorldWrappingPortal.initWrappingPortal(world, box, direction, isInward, portal);
            McHelper.spawnServerEntity(portal);
        }
    }

    private static int processPortalArgumentedCBCommand(CommandContext<class_2168> context, PortalConsumerThrowsCommandSyntaxException invoker) throws CommandSyntaxException {
        Collection entities = class_2186.method_9317(context, (String)"portal");
        for (class_1297 portalEntity : entities) {
            if (portalEntity instanceof Portal) {
                Portal portal = (Portal)portalEntity;
                invoker.accept(portal);
                continue;
            }
            PortalCommand.sendMessage(context, "The target should be portal");
        }
        return 0;
    }

    private static void sendEditBiWayPortalWarning(CommandContext<class_2168> context, Portal portal) {
        if (!PortalExtension.get((Portal)portal).bindCluster && PortalManipulation.findReversePortal(portal) != null) {
            PortalCommand.sendMessage(context, "You are editing a bi-way portal. It's recommended to enable bindCluster or you will get unlinked portal entities. Use command /portal set_portal_nbt {bindCluster:true}");
        }
        if (portal instanceof BreakablePortalEntity) {
            BreakablePortalEntity breakablePortalEntity = (BreakablePortalEntity)portal;
            if (!breakablePortalEntity.unbreakable) {
                PortalCommand.sendMessage(context, "You are editing a breakable portal. It may break if its state is abnormal. It's recommended to make it unbreakable by /portal set_portal_nbt {unbreakable:true}");
            }
        }
    }

    private static void invokeCompleteBiWayBiFacedPortal(CommandContext<class_2168> context, Portal portal) {
        PortalExtension.get((Portal)portal).bindCluster = true;
        PortalCommand.reloadPortal(portal);
        PortalManipulation.completeBiWayBiFacedPortal(portal, p -> PortalCommand.sendMessage(context, "Removed " + String.valueOf(p)), p -> PortalCommand.sendMessage(context, "Added " + String.valueOf(p)), Portal.ENTITY_TYPE);
    }

    private static void invokeCompleteBiFacedPortal(CommandContext<class_2168> context, Portal portal) {
        PortalManipulation.removeOverlappedPortals((class_1937)((class_3218)portal.method_37908()), portal.getOriginPos(), portal.getNormal().method_1021(-1.0), p -> Objects.equals(portal.specificPlayerId, p.specificPlayerId), p -> PortalCommand.sendMessage(context, "Removed " + String.valueOf(p)));
        PortalExtension.get((Portal)portal).bindCluster = true;
        PortalCommand.reloadPortal(portal);
        Portal result = PortalManipulation.completeBiFacedPortal(portal, Portal.ENTITY_TYPE);
        PortalCommand.sendMessage(context, "Added " + String.valueOf(result));
    }

    private static void invokeCompleteBiWayPortal(CommandContext<class_2168> context, Portal portal) {
        PortalManipulation.removeOverlappedPortals((class_1937)MiscHelper.getServer().method_3847(portal.getDestDim()), portal.getDestPos(), portal.transformLocalVecNonScale(portal.getNormal().method_1021(-1.0)), p -> Objects.equals(portal.specificPlayerId, p.specificPlayerId), p -> PortalCommand.sendMessage(context, "Removed " + String.valueOf(p)));
        PortalExtension.get((Portal)portal).bindCluster = true;
        PortalCommand.reloadPortal(portal);
        Portal result = PortalManipulation.completeBiWayPortal(portal, Portal.ENTITY_TYPE);
        PortalCommand.sendMessage(context, "Added " + String.valueOf(result));
    }

    private static void removeSpecificAccessor(CommandContext<class_2168> context, Portal portal) {
        portal.specificPlayerId = null;
        PortalCommand.sendMessage(context, "This portal can be accessed by all players now");
        PortalCommand.sendMessage(context, portal.toString());
    }

    private static void setSpecificAccessor(CommandContext<class_2168> context, Portal portal, class_1297 player) {
        portal.specificPlayerId = player.method_5667();
        PortalCommand.sendMessage(context, "This portal can only be accessed by " + String.valueOf(player.method_5477().method_10851()) + " now");
        PortalCommand.sendMessage(context, portal.toString());
    }

    private static void removeMultidestEntry(CommandContext<class_2168> context, Portal pointedPortal, class_3222 player) {
        PortalManipulation.getPortalCluster(pointedPortal.method_37908(), pointedPortal.getOriginPos(), pointedPortal.getNormal(), p -> true).stream().filter(portal -> player.method_5667().equals(portal.specificPlayerId) || portal.specificPlayerId == null).forEach(portal -> {
            PortalManipulation.removeConnectedPortals(portal, p -> PortalCommand.sendMessage(context, "removed " + p.toString()));
            PortalCommand.sendMessage(context, "removed " + portal.toString());
            portal.method_5650(class_1297.class_5529.field_26998);
        });
    }

    private static void setMultidestEntry(CommandContext<class_2168> context, Portal pointedPortal, class_3222 player, class_5321<class_1937> dimension, class_243 destination, boolean biFaced, boolean biWay) {
        Portal newPortal = PortalManipulation.copyPortal(pointedPortal, Portal.ENTITY_TYPE);
        PortalCommand.removeMultidestEntry(context, pointedPortal, player);
        newPortal.setDestDim(dimension);
        newPortal.setDestination(destination);
        newPortal.specificPlayerId = player.method_5667();
        McHelper.spawnServerEntity(newPortal);
        PortalCommand.configureBiWayBiFaced(newPortal, biWay, biFaced);
    }

    private static void configureBiWayBiFaced(Portal newPortal, boolean biWay, boolean biFaced) {
        if (biFaced && biWay) {
            PortalManipulation.completeBiWayBiFacedPortal(newPortal, p -> {}, p -> {}, Portal.ENTITY_TYPE);
        } else if (biFaced) {
            PortalManipulation.completeBiFacedPortal(newPortal, Portal.ENTITY_TYPE);
        } else if (biWay) {
            PortalManipulation.completeBiWayPortal(newPortal, Portal.ENTITY_TYPE);
        }
    }

    public static void sendPortalInfo(CommandContext<class_2168> context, Portal portal) {
        PortalCommand.sendPortalInfo((class_2561 c) -> {
            PortalCommand.sendMessage(context, c);
            Helper.log(c.getString());
        }, portal);
    }

    public static void sendPortalInfo(Consumer<class_2561> func, Portal portal) {
        func.accept(McHelper.compoundTagToTextSorted(portal.method_5647(new class_2487()), " ", 0));
        func.accept((class_2561)class_2561.method_43470((String)portal.toString()));
        func.accept((class_2561)class_2561.method_43470((String)String.format("Orientation: %s", PortalAPI.getPortalOrientationQuaternion(portal))));
        if (portal.getRotation() != null) {
            func.accept((class_2561)class_2561.method_43470((String)String.format("Rotating Transformation: %s", portal.getRotation())));
        }
    }

    public static void sendMessage(CommandContext<class_2168> context, class_2561 component) {
        ((class_2168)context.getSource()).method_9226(() -> component, false);
    }

    public static void sendMessage(CommandContext<class_2168> context, String message) {
        PortalCommand.sendMessage(context, (class_2561)class_2561.method_43470((String)message));
    }

    private static class_2561 getMakePortalSuccess(Portal portal) {
        return class_2561.method_43469((String)"imm_ptl.command.make_portal.success", (Object[])new Object[]{Double.toString(portal.getWidth()), Double.toString(portal.getHeight()), McHelper.dimensionTypeId((class_5321<class_1937>)portal.method_37908().method_27983()).toString(), portal.getOriginPos().toString(), McHelper.dimensionTypeId(portal.getDestDim()).toString(), portal.getDestPos().toString()});
    }

    private static int placePortalAbsolute(CommandContext<class_2168> context) throws CommandSyntaxException {
        double width = DoubleArgumentType.getDouble(context, (String)"width");
        double height = DoubleArgumentType.getDouble(context, (String)"height");
        class_5321 to = class_2181.method_9289(context, (String)"to").method_27983();
        class_243 dest = class_2277.method_9736(context, (String)"dest");
        Portal portal = PortalManipulation.placePortal(width, height, (class_1297)((class_2168)context.getSource()).method_9207());
        if (portal == null) {
            return 0;
        }
        portal.setDestDim((class_5321<class_1937>)to);
        portal.setDestination(dest);
        McHelper.spawnServerEntity(portal);
        ((class_2168)context.getSource()).method_9226(() -> PortalCommand.getMakePortalSuccess(portal), true);
        return 1;
    }

    private static int placePortalShift(CommandContext<class_2168> context) throws CommandSyntaxException {
        double width = DoubleArgumentType.getDouble(context, (String)"width");
        double height = DoubleArgumentType.getDouble(context, (String)"height");
        class_5321 to = class_2181.method_9289(context, (String)"to").method_27983();
        double dist = DoubleArgumentType.getDouble(context, (String)"dist");
        Portal portal = PortalManipulation.placePortal(width, height, (class_1297)((class_2168)context.getSource()).method_9207());
        if (portal == null) {
            return 0;
        }
        portal.setDestDim((class_5321<class_1937>)to);
        portal.setDestination(portal.getOriginPos().method_1019(portal.getAxisW().method_1036(portal.getAxisH()).method_1021(-dist)));
        McHelper.spawnServerEntity(portal);
        ((class_2168)context.getSource()).method_9226(() -> PortalCommand.getMakePortalSuccess(portal), true);
        return 1;
    }

    public static int teleport(Collection<? extends class_1297> entities, class_5321<class_1937> targetDim, class_243 targetPos) {
        class_3218 targetWorld = MiscHelper.getServer().method_3847(targetDim);
        int numTeleported = 0;
        for (class_1297 class_12972 : entities) {
            ServerTeleportationManager.teleportEntityGeneral(class_12972, targetPos, targetWorld);
            ++numTeleported;
        }
        return numTeleported;
    }

    public static class_2338 getRandomShift(int len) {
        Random rand = new Random();
        return class_2338.method_49637((double)((rand.nextDouble() * 2.0 - 1.0) * (double)len), (double)((rand.nextDouble() * 2.0 - 1.0) * (double)len), (double)((rand.nextDouble() * 2.0 - 1.0) * (double)len));
    }

    public static int processPortalTargetedCommand(CommandContext<class_2168> context, PortalConsumerThrowsCommandSyntaxException processCommand) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1297 entity = source.method_9228();
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            Portal portal = PortalCommand.getPlayerPointingPortal(player, false);
            if (portal == null) {
                source.method_9226(() -> class_2561.method_43470((String)"You are not pointing to any non-global portal. (This command cannot process global portals)"), false);
                return 0;
            }
            processCommand.accept(portal);
        } else if (entity instanceof Portal) {
            processCommand.accept((Portal)entity);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"The command executor should be either a player or a portal entity"), false);
        }
        return 0;
    }

    @Deprecated
    public static Portal getPlayerPointingPortal(class_3222 player, boolean includeGlobalPortal) {
        return PortalCommand.getPlayerPointingPortalRaw((class_1657)player, 1.0f, 100.0, includeGlobalPortal).map(Pair::getFirst).orElse(null);
    }

    @Deprecated
    public static Optional<Pair<Portal, class_243>> getPlayerPointingPortalRaw(class_1657 player, float partialTick, double maxDistance, boolean includeGlobalPortal) {
        return PortalUtils.raytracePortalFromEntityView((class_1297)player, partialTick, maxDistance, includeGlobalPortal, p -> true).map(p -> Pair.of((Object)((Portal)p.getFirst()), (Object)((RayTraceResult)p.getSecond()).hitPos()));
    }

    public static Optional<Pair<Portal, class_243>> raytracePortals(class_1937 world, class_243 from, class_243 to, boolean includeGlobalPortal) {
        return PortalUtils.raytracePortals(world, from, to, includeGlobalPortal, p -> true).map(p -> Pair.of((Object)((Portal)p.getFirst()), (Object)((RayTraceResult)p.getSecond()).hitPos()));
    }

    private static class_243 getRightVec(class_1297 entity) {
        float yaw = entity.method_36454() + 90.0f;
        float radians = -yaw * ((float)Math.PI / 180);
        return new class_243(Math.sin(radians), 0.0, Math.cos(radians));
    }

    private static void updateEntityFullNbt(class_1297 entity, class_2487 nbt) {
        nbt.method_10551("id");
        nbt.method_10551("UUID");
        class_2487 result = entity.method_5647(new class_2487());
        result.method_10543(nbt);
        entity.method_5651(result);
    }

    private static void registerEulerCommands(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"make_portal").requires(s -> s.method_9259(2))).then(class_2170.method_9244((String)"origin", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).then(class_2170.method_9244((String)"width", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(class_2170.method_9244((String)"height", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
            class_243 origin = class_2277.method_9736((CommandContext)context, (String)"origin");
            class_241 rotation = class_2270.method_9716((CommandContext)context, (String)"rotation").method_9709((class_2168)context.getSource());
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            Portal portal = (Portal)Portal.ENTITY_TYPE.method_5883((class_1937)world);
            Validate.notNull((Object)portal);
            portal.setOriginPos(origin);
            portal.setDestination(origin.method_1031(0.0, 10.0, 0.0));
            portal.setDestinationDimension((class_5321<class_1937>)world.method_27983());
            DQuaternion orientationRotation = DQuaternion.fromEulerAngle(new class_243((double)rotation.field_1343, (double)rotation.field_1342, 0.0));
            portal.setOrientationRotation(orientationRotation);
            portal.setWidth(width);
            portal.setHeight(height);
            portal.setScaleTransformation(scale);
            PortalCommand.updateEntityFullNbt(portal, nbt);
            McHelper.spawnServerEntity(portal);
            return 0;
        }))))))));
        builder.then(class_2170.method_9247((String)"set_orientation").then(class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            class_241 rotation = class_2270.method_9716((CommandContext)context, (String)"rotation").method_9709((class_2168)context.getSource());
            DQuaternion orientationRotation = DQuaternion.fromEulerAngle(new class_243((double)rotation.field_1343, (double)rotation.field_1342, 0.0));
            portal.setOrientationRotation(orientationRotation);
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set_this_side").requires(s -> s.method_9259(2))).then(class_2170.method_9244((String)"origin", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).then(class_2170.method_9244((String)"width", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(class_2170.method_9244((String)"height", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            class_243 origin = class_2277.method_9736((CommandContext)context, (String)"origin");
            class_241 rotation = class_2270.method_9716((CommandContext)context, (String)"rotation").method_9709((class_2168)context.getSource());
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
            portal.setOriginPos(origin);
            DQuaternion orientationRotation = DQuaternion.fromEulerAngle(new class_243((double)rotation.field_1343, (double)rotation.field_1342, 0.0));
            portal.setOrientationRotation(orientationRotation);
            portal.setWidth(width);
            portal.setHeight(height);
            PortalCommand.updateEntityFullNbt(portal, nbt);
            PortalCommand.reloadPortal(portal);
        }))))))));
        builder.then(class_2170.method_9247((String)"set_other_side").then(class_2170.method_9244((String)"destination", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<class_2168>)context, portal -> {
            class_243 destination = class_2277.method_9736((CommandContext)context, (String)"destination");
            class_241 rotation = class_2270.method_9716((CommandContext)context, (String)"rotation").method_9709((class_2168)context.getSource());
            portal.setDestination(destination);
            portal.setDestinationDimension((class_5321<class_1937>)((class_2168)context.getSource()).method_9225().method_27983());
            DQuaternion otherSideRotation = DQuaternion.fromEulerAngle(new class_243((double)rotation.field_1343, (double)rotation.field_1342, 0.0));
            PortalState portalState = portal.getPortalState();
            UnilateralPortalState thisSide = UnilateralPortalState.extractThisSide(portalState);
            UnilateralPortalState otherSide = UnilateralPortalState.extractOtherSide(portalState);
            UnilateralPortalState newOtherSide = new UnilateralPortalState.Builder().from(otherSide).orientation(otherSideRotation).build();
            PortalState newPortalState = UnilateralPortalState.combine(thisSide, newOtherSide);
            portal.setPortalState(newPortalState);
            PortalCommand.reloadPortal(portal);
        })))));
    }

    private static void invokeTurnIntoFakeEnterableMirror(CommandContext<class_2168> context, Portal portal) {
        if (portal instanceof Mirror) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"This command targets non-mirror portals"));
            return;
        }
        PortalState portalState = portal.getPortalState();
        assert (portalState != null);
        UnilateralPortalState thisSideState = UnilateralPortalState.extractThisSide(portalState);
        UnilateralPortalState otherSideState = UnilateralPortalState.extractOtherSide(portalState);
        class_1937 fromWorld = portal.method_37908();
        class_1937 toWorld = portal.getDestinationWorld();
        PortalShape specialShape = portal.getPortalShape();
        DQuaternion spacialRotation = portal.getRotationD();
        PortalManipulation.removeConnectedPortals(portal, p -> {});
        portal.method_5650(class_1297.class_5529.field_26998);
        Mirror thisSideMirror = (Mirror)Mirror.ENTITY_TYPE.method_5883(fromWorld);
        assert (thisSideMirror != null);
        thisSideMirror.setDestDim((class_5321<class_1937>)thisSideMirror.method_37908().method_27983());
        thisSideMirror.setOriginPos(thisSideState.position());
        thisSideMirror.setOrientationRotation(thisSideState.orientation());
        thisSideMirror.setDestination(thisSideState.position());
        thisSideMirror.setWidth(thisSideState.width());
        thisSideMirror.setHeight(thisSideState.height());
        thisSideMirror.setPortalShape(specialShape);
        thisSideMirror.setRotationTransformationForMirror(spacialRotation);
        Mirror otherSideMirror = (Mirror)Mirror.ENTITY_TYPE.method_5883(toWorld);
        assert (otherSideMirror != null);
        otherSideMirror.setDestDim((class_5321<class_1937>)otherSideMirror.method_37908().method_27983());
        otherSideMirror.setOriginPos(otherSideState.position());
        otherSideMirror.setOrientationRotation(otherSideState.orientation());
        otherSideMirror.setDestination(otherSideState.position());
        otherSideMirror.setWidth(otherSideState.width());
        otherSideMirror.setHeight(otherSideState.height());
        otherSideMirror.setPortalShape(specialShape.getFlipped());
        otherSideMirror.setRotationTransformationForMirror(spacialRotation.getConjugated());
        McHelper.spawnServerEntity(thisSideMirror);
        McHelper.spawnServerEntity(otherSideMirror);
        Portal invisiblePortal = (Portal)Portal.ENTITY_TYPE.method_5883(fromWorld);
        assert (invisiblePortal != null);
        invisiblePortal.setDestDim((class_5321<class_1937>)toWorld.method_27983());
        invisiblePortal.setPortalState(UnilateralPortalState.combine(thisSideState, otherSideState));
        invisiblePortal.setPortalShape(specialShape);
        invisiblePortal.setIsVisible(false);
        invisiblePortal.setOriginPos(invisiblePortal.getOriginPos().method_1019(portal.getNormal().method_1021(0.001)));
        invisiblePortal.setDestination(invisiblePortal.getDestPos().method_1019(portal.getContentDirection().method_1021(0.001)));
        Portal reverseInvisiblePortal = PortalManipulation.createReversePortal(invisiblePortal, Portal.ENTITY_TYPE);
        McHelper.spawnServerEntity(invisiblePortal);
        McHelper.spawnServerEntity(reverseInvisiblePortal);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"The portal has been turned into a fake enterable mirror. You need to manually make the two sides symmetric. Two invisible portal entities are generated. If you want to remove that, don't forget to remove the invisible portals."), false);
    }

    private static void invokeSculpt(CommandContext<class_2168> context, Portal portal, boolean adjustPortalBounds) {
        Mesh2D mesh2D;
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        @Nullable class_3222 player = ((class_2168)context.getSource()).method_44023();
        ObjectArrayList<class_238> boxes = PortalCommand.gatherCollisionBoxesTouching(portal);
        if (boxes.size() > 40000) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Too many collision boxes to sculpt"));
            return;
        }
        PortalShape originalPortalShape = portal.getPortalShape();
        if (originalPortalShape instanceof SpecialFlatPortalShape) {
            SpecialFlatPortalShape s = (SpecialFlatPortalShape)originalPortalShape;
            mesh2D = s.mesh.copy();
        } else {
            mesh2D = Mesh2D.createNewFullQuadMesh();
        }
        double halfWidth = portal.getWidth() / 2.0;
        double halfHeight = portal.getHeight() / 2.0;
        class_243 axisW = portal.getAxisW();
        class_243 axisH = portal.getAxisH();
        Plane plane = new Plane(portal.getOriginPos(), portal.getNormal());
        double areaBefore = mesh2D.getArea() * halfWidth * halfHeight;
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            int count = 0;
            for (class_238 box : boxes) {
                ObjectArrayList<Vec2d> polygonVertexes = GeometryUtil.getSlicePolygonOfCube(box, plane, axisW, axisH, halfWidth, halfHeight);
                mesh2D.subtractPolygon(polygonVertexes);
                if (++count % 10000 != 0) continue;
                mesh2D.compact();
            }
            mesh2D.simplify();
            mesh2D.compact();
        }, class_156.method_18349());
        future.thenRun(() -> server.execute(() -> {
            if (portal.method_31481()) {
                return;
            }
            double meshArea = mesh2D.getArea();
            double areaAfter = meshArea * halfWidth * halfHeight;
            if (Math.abs(4.0 - meshArea) < 1.0E-5) {
                portal.setPortalShapeToDefault();
                if (player != null) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"Portal shape is still rectangular now."));
                }
                return;
            }
            if (Math.abs(meshArea) < 1.0E-5) {
                if (player != null) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"Sculpt failed because the blocks fully cover the portal."));
                }
                return;
            }
            PortalCommand.setPortalShapeByMesh(portal, mesh2D, adjustPortalBounds);
            portal.getDefaultAnimation().setDisableUntil(portal.method_37908().method_8510() + 5L);
            PortalCommand.reloadPortal(portal);
            if (player != null) {
                player.method_43496((class_2561)class_2561.method_43469((String)"imm_ptl.sculpted", (Object[])new Object[]{String.format("%.4f", areaBefore - areaAfter), String.format("%.4f", areaBefore), String.format("%.4f", areaAfter)}));
            }
        }));
        future.exceptionally(throwable -> {
            LOGGER.error("Error when sculpting portal {}", (Object)portal, throwable);
            if (player != null) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Failed to sculpt the portal. See the server log for detail."));
            }
            return null;
        });
        ServerTaskList.of(server).addTask(MyTaskList.withDelay(5, MyTaskList.oneShotTask(() -> {
            if (!future.isDone() && player != null) {
                player.method_43496((class_2561)class_2561.method_43471((String)"imm_ptl.sculpting_in_progress"));
            }
        })));
    }

    private static void setPortalShapeByMesh(Portal portal, Mesh2D mesh2D, boolean adjustPortalBounds) {
        if (adjustPortalBounds) {
            Mesh2D.Rect boundingBox = mesh2D.getBoundingBox();
            double centerLX = (boundingBox.minX() + boundingBox.maxX()) / 2.0;
            double centerLY = (boundingBox.minY() + boundingBox.maxY()) / 2.0;
            double lWidth = boundingBox.maxX() - boundingBox.minX();
            double lHeight = boundingBox.maxY() - boundingBox.minY();
            mesh2D.transformPoints(input -> new Vec2d((input.x() - centerLX) / (lWidth / 2.0), (input.y() - centerLY) / (lHeight / 2.0)));
            double oldHalfWidth = portal.getWidth() / 2.0;
            double oldHalfHeight = portal.getHeight() / 2.0;
            double newPortalWidth = oldHalfWidth * lWidth;
            double newPortalHeight = oldHalfHeight * lHeight;
            class_243 centerOffset = portal.getAxisW().method_1021(centerLX * oldHalfWidth).method_1019(portal.getAxisH().method_1021(centerLY * oldHalfHeight));
            class_243 otherSideCenterOffset = portal.transformLocalVec(centerOffset);
            portal.setOriginPos(portal.getOriginPos().method_1019(centerOffset));
            portal.setDestination(portal.getDestPos().method_1019(otherSideCenterOffset));
            portal.setWidth(newPortalWidth);
            portal.setHeight(newPortalHeight);
        }
        portal.setPortalShape(new SpecialFlatPortalShape(mesh2D));
    }

    @NotNull
    private static ObjectArrayList<class_238> gatherCollisionBoxesTouching(Portal portal) {
        class_238 areaBox = portal.method_5829();
        ObjectArrayList boxes = new ObjectArrayList();
        for (class_265 blockCollision : portal.method_37908().method_20812((class_1297)portal, areaBox)) {
            if (blockCollision.method_1110()) continue;
            boxes.addAll((Collection)blockCollision.method_1090());
        }
        return boxes;
    }

    public static interface PortalConsumerThrowsCommandSyntaxException {
        public void accept(Portal var1) throws CommandSyntaxException;
    }

    public static class RemoteCallables {
        @Environment(value=EnvType.CLIENT)
        public static void clientAccelerate(class_243 vec) {
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            McHelper.setWorldVelocity((class_1297)player, vec);
        }
    }
}

